/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Vec2d;

public record DeltaUnilateralPortalState(@Nullable Vec3 offset, @Nullable DQuaternion rotation, @Nullable Vec2d sizeScaling) {
    public static final DeltaUnilateralPortalState identity = new DeltaUnilateralPortalState(null, null, null);

    public DeltaUnilateralPortalState getInverse() {
        return new DeltaUnilateralPortalState(this.offset == null ? null : this.offset.m_82490_(-1.0), this.rotation == null ? null : this.rotation.getConjugated(), this.sizeScaling == null ? null : new Vec2d(1.0 / this.sizeScaling.x(), 1.0 / this.sizeScaling.y()));
    }

    public DeltaUnilateralPortalState combine(DeltaUnilateralPortalState then) {
        return new DeltaUnilateralPortalState(Helper.combineNullable(this.offset, then.offset, Vec3::m_82549_), Helper.combineNullable(this.rotation, then.rotation, DQuaternion::hamiltonProduct), Helper.combineNullable(this.sizeScaling, then.sizeScaling, (a, b) -> new Vec2d(a.x() * b.x(), a.y() * b.y())));
    }

    public static DeltaUnilateralPortalState fromTag(CompoundTag tag) {
        return new DeltaUnilateralPortalState(Helper.getVec3dOptional(tag, "offset"), tag.m_128441_("rotation") ? DQuaternion.fromTag((Tag)tag.m_128469_("rotation")) : null, tag.m_128441_("sizeScalingX") ? new Vec2d(tag.m_128459_("sizeScalingX"), tag.m_128459_("sizeScalingY")) : null);
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        if (this.offset != null) {
            Helper.putVec3d(tag, "offset", this.offset);
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", this.rotation.toTag());
        }
        if (this.sizeScaling != null) {
            tag.m_128347_("sizeScalingX", this.sizeScaling.x());
            tag.m_128347_("sizeScalingY", this.sizeScaling.y());
        }
        return tag;
    }

    public DeltaUnilateralPortalState getPartial(double progress) {
        return new DeltaUnilateralPortalState(this.offset == null ? null : this.offset.m_82490_(progress), this.rotation == null ? null : DQuaternion.interpolate(DQuaternion.identity, this.rotation, progress), this.sizeScaling == null ? null : new Vec2d(Mth.m_14139_((double)progress, (double)1.0, (double)this.sizeScaling.x()), Mth.m_14139_((double)progress, (double)1.0, (double)this.sizeScaling.y())));
    }

    public static DeltaUnilateralPortalState interpolate(DeltaUnilateralPortalState a, DeltaUnilateralPortalState b, double progress) {
        return a.getPartial(1.0 - progress).combine(b.getPartial(progress));
    }

    public DeltaUnilateralPortalState getFlipped() {
        return new DeltaUnilateralPortalState(this.offset, this.rotation == null ? null : this.rotation.hamiltonProduct(PortalManipulation.flipAxisW), this.sizeScaling);
    }

    public void apply(UnilateralPortalState.Builder builder) {
        if (this.offset != null) {
            builder.offset(this.offset);
        }
        if (this.rotation != null) {
            builder.rotate(this.rotation);
        }
        if (this.sizeScaling != null) {
            builder.scaleWidth(this.sizeScaling.x());
            builder.scaleHeight(this.sizeScaling.y());
        }
    }

    public DeltaUnilateralPortalState purgeFPError() {
        Vec2d sizeScaling;
        DQuaternion rotation;
        Vec3 offset = this.offset;
        if (offset != null && offset.m_82556_() < 1.0E-4) {
            offset = null;
        }
        if ((rotation = this.rotation) != null && DQuaternion.isClose(rotation, DQuaternion.identity, 1.0E-4)) {
            rotation = null;
        }
        if ((sizeScaling = this.sizeScaling) != null && Math.abs(sizeScaling.x() - 1.0) < 1.0E-5 && Math.abs(sizeScaling.y() - 1.0) < 1.0E-5) {
            sizeScaling = null;
        }
        return new DeltaUnilateralPortalState(offset, rotation, sizeScaling);
    }

    public boolean isIdentity() {
        return this.offset == null && this.rotation == null && this.sizeScaling == null;
    }

    @Override
    public String toString() {
        String str = Stream.of(this.offset == null ? null : "offset=(%.3f,%.3f,%.3f)".formatted(this.offset.m_7096_(), this.offset.m_7098_(), this.offset.m_7094_()), this.rotation == null ? null : "rotation=(%.3f,%.3f,%.3f,%.3f)".formatted(this.rotation.x, this.rotation.y, this.rotation.z, this.rotation.w), this.sizeScaling == null ? null : "sizeScaling=(%.3f,%.3f)".formatted(this.sizeScaling.x(), this.sizeScaling.y())).filter(Objects::nonNull).reduce((a, b) -> a + ", " + b).orElse("");
        return "Delta(" + str + ")";
    }

    public static DeltaUnilateralPortalState fromDiff(UnilateralPortalState before, UnilateralPortalState after) {
        return new DeltaUnilateralPortalState(after.position().m_82546_(before.position()), after.orientation().hamiltonProduct(before.orientation().getConjugated()), new Vec2d(before.width() == 0.0 ? 1.0 : after.width() / before.width(), before.height() == 0.0 ? 1.0 : after.height() / before.height()));
    }

    public static class Builder {
        @Nullable
        private Vec3 offset;
        @Nullable
        private DQuaternion rotation;
        @Nullable
        private Vec2d sizeScaling;

        public Builder offset(Vec3 offset) {
            this.offset = offset;
            return this;
        }

        public Builder rotate(DQuaternion rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder scaleSize(double scale) {
            this.sizeScaling = new Vec2d(scale, scale);
            return this;
        }

        public Builder scaleSize(Vec2d scale) {
            this.sizeScaling = scale;
            return this;
        }

        public DeltaUnilateralPortalState build() {
            return new DeltaUnilateralPortalState(this.offset, this.rotation, this.sizeScaling);
        }
    }
}

